using System;
using System.Collections.Generic;
using System.Text;
using System.Xml;
using System.Configuration;
using System.Reflection;
using System.Windows.Forms;

namespace Transform
{
	public class ConfigSettings
   {
		private ConfigSettings() {}
		//
		// getPosition()
		// ~~~~~~~~~~~~~
		// Loads the top, left, width and height values of the current window that were saved to the
		// applications configuration file last time the window was closed
		//
		// frm  Reference to the form whose properties are being set
		// 
		public static void getPosition(Form frm)
		{
			try
         {
				string[] position = readSetting(frm.Name).Split(' ');
            if (position[0].Equals("max"))
				{
					frm.WindowState = FormWindowState.Maximized;
					return;
            }
            else if (position[0].Equals("min"))
            {
					frm.WindowState = FormWindowState.Minimized;
               return;
            }
				else
				{
               frm.Top = Convert.ToInt32(position[0]);
               frm.Left = Convert.ToInt32(position[1]);
               frm.Width = Convert.ToInt32(position[2]);
               frm.Height = Convert.ToInt32(position[3]);
            }
			}	
         catch
         {
			} 
      }

		//
		// savePosition()
		// ~~~~~~~~~~~~~~
		// Saves the top, left, width and height values of the current window to the
		// applications configuration file. This is usually called from the forms
		// FormClosed() event.
		//
		// frm  Reference to the form whose properties are being set
		//
		public static void savePosition(Form frm)
		{
			WriteSetting(frm, frm.Name, "" + frm.Top + " " + frm.Left + " " + frm.Width + " " + frm.Height);
		}

		//
		// readSetting()
		// ~~~~~~~~~~~~~
		// Reads a particular configuration setting specified in the key parameter for the
		// current application
		//
		// key  contains the name of the configuration key that is to be read.
		//
      public static string readSetting(string key)
      {
			// load the default configuration document for current the current application
			XmlDocument doc = loadConfigDocument(key);

         // retrieve the appSettings node from the XML document
         XmlNode node = doc.SelectSingleNode("//appSettings");
			if (node == null)
			{
				throw new InvalidOperationException("appSettings section not found in config file.");
			}
			else
			{
			   try
            {
					XmlElement elem = (XmlElement)node.SelectSingleNode(string.Format("//add[@key='{0}']", key));
					return elem.GetAttribute("value");              
            }
            catch
            {
					WriteSetting(null,key, "");
					doc = loadConfigDocument(key);
					node = doc.SelectSingleNode("//appSettings");
					XmlElement elem = (XmlElement)node.SelectSingleNode(string.Format("//add[@key='{0}']", key));
					return elem.GetAttribute("value");     
            }
			}
			return null;
		}
			

		
        public static void WriteSetting(Form f, string key, string value)
        {
            // load config document for current assembly
            XmlDocument doc = loadConfigDocument(key);

            // retrieve appSettings node
            XmlNode node =  doc.SelectSingleNode("//appSettings");

            if (node == null)
                throw new InvalidOperationException("appSettings section not found in config file.");

            try
            {
                // select the 'add' element that contains the key
                XmlElement elem = (XmlElement)node.SelectSingleNode(string.Format("//add[@key='{0}']", key));
               
                if ((""+f.WindowState).Equals("Maximized"))
                    value = "max";
                else if ((""+f.WindowState).Equals("Minimized"))
                    value = "min";

                if (elem != null)
                {
                    // add value for key
                    elem.SetAttribute("value", value);
                }
                else
                {
                    // key was not found so create the 'add' element 
                    // and set it's key/value attributes 
                    elem = doc.CreateElement("add");
                    elem.SetAttribute("key", key);
                    elem.SetAttribute("value", value);
                    node.AppendChild(elem);
                }
                doc.Save(getConfigFilePath());
            }
            catch
            {
                throw;
            }
        }

        private static XmlDocument loadConfigDocument(string key)
        {
            XmlDocument doc = null;
            try
            {
                doc = new XmlDocument();
                doc.Load(getConfigFilePath());
                return doc;
            }
            catch (System.IO.FileNotFoundException e)
            {
                doc = createConfigFile(key);
                return doc;
            }
        }

        private static string getConfigFilePath()
        {
            return Assembly.GetExecutingAssembly().Location + ".config";        
        }

        private static XmlDocument createConfigFile(string key)
        {
            XmlDocument xmlDoc = new XmlDocument();
            XmlTextWriter xmlWriter = new XmlTextWriter(getConfigFilePath(), System.Text.Encoding.UTF8);
            xmlWriter.Formatting = Formatting.Indented;
            xmlWriter.WriteProcessingInstruction("xml", "version='1.0' encoding='UTF-8'");
            xmlWriter.WriteStartElement("configuration");
            xmlWriter.Close();
            xmlDoc.Load(getConfigFilePath());

            XmlNode configuration = xmlDoc.DocumentElement;
            XmlElement appSettings = xmlDoc.CreateElement("appSettings");
            configuration.AppendChild(appSettings);
            xmlDoc.Save(getConfigFilePath());

            return xmlDoc;
        }
    }

}
